#!/bin/bash

# 提示用户输入仓库名称
echo "请输入仓库名称（不要使用中文）："
read repo_name

# 创建仓库目录
repo_path="/var/hg/$repo_name"
mkdir -p "$repo_path"

# 检查目录是否创建成功
if [ ! -d "$repo_path" ]; then
    echo "目录创建失败，请检查权限或磁盘空间。"
    exit 1
fi

# 初始化Mercurial仓库
hg init "$repo_path"

# 提示用户输入description和contact的内容
echo "请输入description的内容："
read description
echo "请输入contact的内容："
read contact

# 构建hgrc文件内容
hgrc_content="# example repository config (see 'hg help config' for more info)
[paths]
default = https://hg.nnsui.com/$repo_name/ 

# path aliases to other clones of this repo in URLs or filesystem paths
# (see 'hg help config.paths' for more info)
#
# default:pushurl = ssh://jdoe@example.net/hg/jdoes-fork
# my-fork         = ssh://jdoe@example.net/hg/jdoes-fork
# my-clone        = /home/jdoe/jdoes-clone

[ui]
# name and email (local to this repository, optional), e.g.
# username = Jane Doe <jdoe@example.com>

[web]
encoding = UTF-8
description = $description
contact = $contact"

# 写入.hg/hgrc文件
hgrc_path="$repo_path/.hg/hgrc"
echo "$hgrc_content" | sudo tee "$hgrc_path" > /dev/null

# 更改仓库所有者为www-data
sudo chown -R www-data:www-data "$repo_path"

# 更改仓库权限为755
sudo chmod -R 755 "$repo_path"

echo "仓库已成功创建并配置在 $repo_path"
echo "hgrc文件已更新。"
echo "仓库所有者和权限已更改。"