#!/bin/bash

echo "Please enter the repository name (not in Chinese):"
read repo_name

repo_path="/var/hg/$repo_name"
mkdir -p "$repo_path"

if [ ! -d "$repo_path" ]; then
    echo "Directory creation failed, please check permissions or disk space."
    exit 1
fi

hg init "$repo_path"

sudo chown -R www-data:www-data "$repo_path"


sudo chmod -R 755 "$repo_path"

echo "Please enter the description :"
read description
echo "Please enter the contact :"
read contact

hgrc_content="[web]
description = $description
contact = $contact"

hgrc_path="$repo_path/.hg/hgrc"
echo "$hgrc_content" | sudo tee "$hgrc_path" > /dev/null

echo "New repositoryinitialized successfully in $repo_path"
echo "The hgrc file has been updated."