# Ubuntu下 apache2 和 hgweb 的安装
## 安装
1. 安装 apache2、 hgweb
```shell 
sudo apt install apache2 mercurial libapache2-mod-wsgi-py3 apache2-utils
```
2. 验证环境
```shell
# 启用apache2
sudo systemctl start apache2
sudo systemctl enable apache2   

# 查看HG
hg --version
```
3. 创建文件夹和默认仓库
```shell
sudo mkdir /var/hg
sudo hg init /var/hg/myrepo

#设置文件夹权限
sudo chown -R www-data:www-data /var/hg
sudo chmod -R 755 /var/hg
```
4. 创建 ```/var/hg/hgweb.config``` 文件
```shell
[web]
allow_push = *
push_ssl = true
allow_archive = gz, zip, bz2

[paths]
/ = /var/hg/*
```

5. 创建 ``` /var/hg/hgweb.wsgi``` 文件
```shell
import sys
import os
from mercurial import demandimport
demandimport.enable()

# 设置编码为UTF-8
if not isinstance(os.environ.get('PYTHONIOENCODING'), str):
    os.environ['PYTHONIOENCODING'] = 'utf-8'

from mercurial.hgweb.hgwebdir_mod import hgwebdir

application = hgwebdir(b'/var/hg/hgweb.config')
```
6. 创建 ```/etc/apache2/sites-available/hgweb.conf```
```shell
<VirtualHost *:80>
    ServerName repo.nnsui.com

    RewriteEngine On
    RewriteCond %{HTTPS} !=on
    RewriteRule ^/?(.*) https://%{SERVER_NAME}/$1 [R,L]
</VirtualHost>

<VirtualHost *:443>
    ServerName repo.nnsui.com

    SSLEngine On
    SSLCertificateFile /etc/apache2/cert/nnsui.com.pem
    SSLCertificateKeyFile /etc/apache2/cert/nnsui.com.key

    WSGIScriptAlias / /var/hg/hgweb.wsgi
    WSGIDaemonProcess hgweb user=www-data group=www-data processes=2 threads=15
    WSGIProcessGroup hgweb

    <Directory /var/hg>
        Require all granted
    </Directory>

    <Location "/">
        AuthType Basic
        AuthName "Restricted Access"
        AuthUserFile /etc/apache2/hgweb.htpasswd
        Require valid-user
        <Limit GET>
            Require all granted
        </Limit>
        <LimitExcept GET>
            Require valid-user
        </LimitExcept>
    </Location>
</VirtualHost>
```

7. 启用apache2模块
```shell
sudo a2enmod wsgi
sudo a2enmod ssl
sudo a2enmod rewrite
```
8. 启动！
```shell
# 检查配置
sudo apachectl configtest
# 重启
sudo a2ensite hgweb

sudo systemctl restart apache2
```
9. 创建 ```htpasswd``` 文件并添加用户
```shell
sudo htpasswd -c /etc/apache2/hgweb.htpasswd pluto
```

10. 